/**
 * Adcaver Ad Helper Admin JavaScript
 *
 * Adds minor interactivity to the plugin's settings page.
 *
 * @package    Adcaver_Ad_Helper
 * @subpackage Adcaver_Ad_Helper/admin/assets/js
 * @author     Edu Brazeal, Adcaver Team <https://edubrazeal.com>
 * @version    1.0.0
 */

/* jshint esversion: 6 */
/* globals jQuery */

(function($) {
	'use strict';

	$(function() {

		/**
		 * Auto-selects the text in read-only shortcode input fields when focused.
		 */
		function handleShortcodeInputFocus() {
			$('.adcaver-shortcode-table input.readonly').on('focus', function() {
				// Use a slight timeout to ensure focus is fully established before selecting
				const inputElement = this;
				setTimeout(function() {
					inputElement.select();
				}, 50);
			});
		}

		// --- INITIALIZE ---
		handleShortcodeInputFocus();

	});

})(jQuery);