<?php
/**
 * Adcaver Ad Helper Settings Page View
 *
 * Renders the HTML for the plugin's settings page in the WordPress admin.
 *
 * @package    Adcaver_Ad_Helper
 * @subpackage Adcaver_Ad_Helper/admin/views
 * @author     Edu Brazeal, Adcaver Team <https://edubrazeal.com>
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

?>
<div class="wrap adcaver-helper-settings-wrap">
	<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>

	<div class="adcaver-instructions notice notice-info inline">
		<h2><?php esc_html_e( 'How to Use Adcaver Ad Helper', 'adcaver-ad-helper' ); ?></h2>
		<ol>
			<li><?php
				/* translators: %s: The URL to the Adcaver website. */
				printf( wp_kses_post( __( '<strong>Sign up or log in</strong> to your Publisher account on <a href="%s" target="_blank">Adcaver.com</a>.', 'adcaver-ad-helper' ) ), esc_url( ADCAVER_SERVER_URL ) );
			?></li>
			<li><?php esc_html_e( 'In your Adcaver Publisher Dashboard, click "Add New Site" and enter your website URL.', 'adcaver-ad-helper' ); ?></li>
			<li><?php esc_html_e( 'Adcaver will provide you with a unique numeric Site ID and may provide a Verification Code (if your site isn\'t automatically approved).', 'adcaver-ad-helper' ); ?></li>
			<li><?php esc_html_e( 'Enter your Site ID below. This is required for all ad formats. Use 1234 as site ID then change it when your site is approved', 'adcaver-ad-helper' ); ?></li>
			<li><?php esc_html_e( 'If you received a Verification Code, paste it into the field below. Then, visit your Adcaver dashboard and click "Check Verification" for your site.', 'adcaver-ad-helper' ); ?></li>
			<li><?php esc_html_e( 'Configure Automatic Ad Placements for Posts, Pages, or Homepage, or enable Overlay Ad Formats below.', 'adcaver-ad-helper' ); ?></li>
			<li><?php esc_html_e( 'Alternatively, use the shortcodes provided for manual placement within your posts, pages, or widgets.', 'adcaver-ad-helper' ); ?></li>
			<li><?php esc_html_e( 'Save changes.', 'adcaver-ad-helper' ); ?></li>
		</ol>
	</div>

	<form action="options.php" method="post">
		<?php
		settings_fields( 'adcaver_helper_options_group' );

		do_settings_sections( ADCAVER_HELPER_SETTINGS_SLUG );

		submit_button( __( 'Save Settings', 'adcaver-ad-helper' ) );
		?>
	</form>
</div>
