<?php
/**
 * Adcaver Ad Helper Uninstall
 *
 * Handles tasks run only when the plugin is deleted.
 *
 * @package    Adcaver_Ad_Helper
 * @author     Edu Brazeal, Adcaver Team <https://edubrazeal.com>
 */

// If uninstall not called from WordPress, exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Check if the user has permissions to delete plugins.
if ( ! current_user_can( 'delete_plugins' ) ) {
    wp_die( esc_html__( 'You do not have permission to uninstall this plugin.', 'adcaver-ad-helper' ) );
}

// Define the option name used by the plugin.
$option_name = 'adcaver_helper_settings'; // Should match ADCAVER_HELPER_OPTION_NAME if defined

// Delete the plugin's settings option from the database.
delete_option( $option_name );

// If using site options in a multisite network:
// delete_site_option( $option_name );

// Add any other cleanup tasks here, like removing custom database tables (if any were created).
// Example:
// global $wpdb;
// $wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}my_custom_table" );